-- Rationalism_Opener.lua
-- Author: Machiavelli
-- DateCreated: 6/2/2012 7:42:07 PM
--------------------------------------------------------------
function ScienceAndCultureOnPopulationGrowth(hexX, hexY, population, citySize)
	local plot = Map.GetPlot(ToGridFromHex(hexX, hexY));
	local city = plot:GetPlotCity();
	local player = Players[city:GetOwner()];
	local policyID = GameInfoTypes["POLICY_RATIONALISM"];

	-- Only run this if the player has the Rationalism opener policy and the population is larger than the city has been and the population is greater than 10
	if(player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID) and city:GetHighestPopulation() <= population and population >= 10) then
		-- Handle the Science --------------
		local team = Teams[player:GetTeam()];
		local teamTechs = team:GetTeamTechs();
		local currentTech = player:GetCurrentResearch();
		local researchProgress = teamTechs:GetResearchProgress(currentTech);
		-- Formula for the bonus science
		--local bonusScience = 5 * population;
		local bonusScience = 25;
		-- Give the bonus science
		teamTechs:SetResearchProgress(currentTech, researchProgress + bonusScience);

		-- Handle the Culture --------------
		local currentCulture = player:GetJONSCulture();
		-- Formula for the bonus culture
		--local bonusCulture = 5 * population;
		local bonusCulture = 25;
		-- Give the bonus culture
		player:SetJONSCulture(currentCulture + bonusCulture);

		-- Send a notification to the player --------------
		local text = Locale.ConvertTextKey("TXT_KEY_SCIENCE_AND_CULTURE_FROM_CITY_GROWTH", tostring(bonusScience), tostring(bonusCulture), city:GetName());
		player:AddNotification(NotificationTypes.NOTIFICATION_GENERIC, text, text);
	end
end
Events.SerialEventCityPopulationChanged.Add(ScienceAndCultureOnPopulationGrowth);